/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.IconGraphicImage;
import ibm.nways.jdm8260.DeviceView.NetworkSetLike;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class NetworkSet
implements NetworkSetLike,
ActionListener {
    private static final String[][] typeOfNetworks = new String[][]{{"none", "None"}, {"other", "None"}, {"isolated", "Other"}, {"none", "None"}, {"per-module", "None"}, {"front-panel", "Other"}, {"ethernet-1", "Ethernet"}, {"ethernet-2", "Ethernet"}, {"ethernet-3", "Ethernet"}, {"token-ring-1", "TR8250"}, {"token-ring-2", "TR8250"}, {"token-ring-3", "TR8250"}, {"token-ring-4", "TR8250"}, {"token-ring-5", "TR8250"}, {"token-ring-6", "TR8250"}, {"token-ring-7", "TR8250"}, {"fddi-1", "FDDI"}, {"fddi-2", "FDDI"}, {"fddi-3", "FDDI"}, {"fddi-4", "FDDI"}, {"per-connector", "None"}, {"isolated-1", "Other"}, {"isolated-2", "Other"}, {"isolated-3", "Other"}, {"isolated-4", "Other"}, {"isolated-5", "Other"}, {"isolated-6", "Other"}, {"isolated-7", "Other"}, {"isolated-8", "Other"}, {"isolated-9", "Other"}, {"isolated-10", "Other"}, {"isolated-11", "Other"}, {"ethernet-4", "Ethernet"}, {"ethernet-5", "Ethernet"}, {"ethernet-6", "Ethernet"}, {"ethernet-7", "Ethernet"}, {"ethernet-8", "Ethernet"}, {"8260-token-ring-1", "TR8260"}, {"8260-token-ring-2", "TR8260"}, {"8260-token-ring-3", "TR8260"}, {"8260-token-ring-4", "TR8260"}, {"8260-token-ring-5", "TR8260"}, {"8260-token-ring-6", "TR8260"}, {"8260-token-ring-7", "TR8260"}, {"8260-token-ring-8", "TR8260"}, {"8260-token-ring-9", "TR8260"}, {"8260-token-ring-10", "TR8260"}, {"fast-ethernet-1", "None"}, {"none", "None"}, {"none", "None"}, {"none", "None"}, {"none", "None"}, {"none", "None"}, {"atm-native", "ATM"}, {"atm-lan-emulation-802-5", "ATM"}, {"atm-lan-emulation-802-3", "ATM"}, {"atm-lan-emulation-unconfig", "ATM"}, {"vbridge", "None"}, {"lan", "None"}, {"fast-ethernet-2", "None"}, {"fast-ethernet-3", "None"}, {"fast-ethernet-4", "None"}};
    private Vector listOfNetworks = new Vector();
    protected Point location;
    protected GraphicContainer graphicContainer;
    protected String networkSetType;
    protected String networkSetGif;
    protected HubInfoLike hub;

    public void dispose() {
        this.hub = null;
        this.graphicContainer = null;
        this.location = null;
        if (this.listOfNetworks != null) {
            this.listOfNetworks.removeAllElements();
        }
    }

    public static String getTypeOfNetwork(int n) {
        return typeOfNetworks[n][0];
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, Point point, GraphicContainer graphicContainer, String string, String string2) {
        this.hub = hubInfoLike;
        this.location = point;
        this.graphicContainer = graphicContainer;
        this.networkSetType = string;
        this.networkSetGif = string2;
        try {
            int n = 0;
            while (true) {
                if (typeOfNetworks[n][1].equals(this.networkSetType)) {
                    this.listOfNetworks.addElement(typeOfNetworks[n][0]);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void draw() {
        IconGraphicImage iconGraphicImage = new IconGraphicImage(this.hub.getBrowser().imageFrom((Object)this, this.networkSetGif), this.location, 2, null, null);
        iconGraphicImage.setFlyOver(new GraphicFlyOver(this.hub.getBundle().getString(this.networkSetType)));
        Enumeration enumeration = this.listOfNetworks.elements();
        while (enumeration.hasMoreElements()) {
            iconGraphicImage.addPopupMenuItem(this.getMenuItem((String)enumeration.nextElement()));
        }
        this.graphicContainer.add((GraphicComponent)iconGraphicImage);
    }

    protected MenuItem getMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.paramString().substring(actionEvent.paramString().lastIndexOf("cmd") + 4);
        this.hub.getNetworksWindow().highlightNetwork(string);
    }

    public static boolean isNetworkType(String string) {
        boolean bl = false;
        try {
            int n = 0;
            while (!typeOfNetworks[n][0].equals(string)) {
                ++n;
            }
            bl = true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return bl;
    }
}

